<?= $this->extend('frontend/layouts/main') ?>

<?= $this->section('pageTitle') ?><?= lang('Registration.pageTitle') ?><?= $this->endSection() ?>

<?= $this->section('mainContent') ?>
<div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-md">
    <h1 class="text-3xl font-bold mb-2 text-center text-gray-800"><?= lang('Registration.mainHeading') ?></h1>
    <p class="text-gray-600 text-center mb-8"><?= lang('Registration.subHeading') ?></p>

    <?= form_open(route_to('register.create')) ?>
    <?= csrf_field() ?>

    <div class="space-y-4">
        <!-- Name -->
        <div>
            <label for="name" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Registration.labelName') ?></label>
            <input type="text" name="name" id="name" class="bg-gray-50 border <?= service('validation')->hasError('name') ? 'border-red-500' : 'border-gray-300' ?> text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" placeholder="<?= lang('Registration.placeholderName') ?>" value="<?= old('name') ?>" required>
            <?php if (service('validation')->hasError('name')): ?>
                <p class="mt-1 text-xs text-red-600"><?= service('validation')->getError('name') ?></p>
            <?php endif ?>
        </div>

        <!-- WhatsApp -->
        <div>
            <label for="phone_number" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Registration.labelWhatsapp') ?></label>
            <input type="tel" name="phone_number" id="phone_number" class="bg-gray-50 border <?= service('validation')->hasError('phone_number') ? 'border-red-500' : 'border-gray-300' ?> text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" placeholder="<?= lang('Registration.placeholderWhatsapp') ?>" value="<?= old('phone_number', '+') ?>" required>
            <?php if (service('validation')->hasError('phone_number')): ?>
                <p class="mt-1 text-xs text-red-600"><?= service('validation')->getError('phone_number') ?></p>
            <?php endif ?>
        </div>
        
        <!-- Email -->
        <div>
            <label for="email" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Registration.labelEmail') ?></label>
            <input type="email" name="email" id="email" class="bg-gray-50 border <?= service('validation')->hasError('email') ? 'border-red-500' : 'border-gray-300' ?> text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" placeholder="<?= lang('Registration.placeholderEmail') ?>" value="<?= old('email') ?>" required>
            <?php if (service('validation')->hasError('email')): ?>
                <p class="mt-1 text-xs text-red-600"><?= service('validation')->getError('email') ?></p>
            <?php endif ?>
        </div>

        <!-- Password & Confirmation -->
        <div class="grid md:grid-cols-2 gap-4">
            <div>
                <label for="password" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Registration.labelPassword') ?></label>
                <input type="password" name="password" id="password" class="bg-gray-50 border <?= service('validation')->hasError('password') ? 'border-red-500' : 'border-gray-300' ?> text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" placeholder="<?= lang('Registration.placeholderPassword') ?>" required>
                 <?php if (service('validation')->hasError('password')): ?>
                    <p class="mt-1 text-xs text-red-600"><?= service('validation')->getError('password') ?></p>
                <?php endif ?>
            </div>
            <div>
                <label for="password_confirm" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Registration.labelPasswordConfirm') ?></label>
                <input type="password" name="password_confirm" id="password_confirm" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
            </div>
        </div>
        
        <hr class="border-gray-200">

        <!-- Optional Fields -->
        <div>
            <label for="kta_number" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Registration.labelKta') ?></label>
            <input type="text" name="kta_number" id="kta_number" class="bg-gray-50 border <?= service('validation')->hasError('kta_number') ? 'border-red-500' : 'border-gray-300' ?> text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" placeholder="<?= lang('Registration.placeholderKta') ?>" value="<?= old('kta_number') ?>">
            <?php if (service('validation')->hasError('kta_number')): ?>
                <p class="mt-1 text-xs text-red-600"><?= service('validation')->getError('kta_number') ?></p>
            <?php endif ?>
        </div>
        <div>
            <label for="birth_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Registration.labelBirthdate') ?></label>
            <input type="date" name="birth_date" id="birth_date" class="bg-gray-50 border <?= service('validation')->hasError('birth_date') ? 'border-red-500' : 'border-gray-300' ?> text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5 disabled:bg-gray-200 disabled:cursor-not-allowed" value="<?= old('birth_date') ?>" disabled>
            <p id="birth_date_help" class="mt-2 text-xs text-gray-500 transition-colors duration-300"><?= lang('Registration.helpBirthdate') ?></p>
             <?php if (service('validation')->hasError('birth_date')): ?>
                <p class="mt-1 text-xs text-red-600"><?= service('validation')->getError('birth_date') ?></p>
            <?php endif ?>
        </div>

        <!-- Submit Button -->
        <div class="pt-4">
             <button type="submit" class="w-full text-white bg-indigo-600 hover:bg-indigo-700 focus:ring-4 focus:outline-none focus:ring-indigo-300 font-medium rounded-lg text-sm px-5 py-3 text-center"><?= lang('Registration.buttonSubmit') ?></button>
        </div>
       
        <p class="text-sm font-light text-gray-500 text-center">
            <?= lang('Registration.loginLinkText') ?> <a href="<?= route_to('login.show') ?>" class="font-medium text-indigo-600 hover:underline"><?= lang('Registration.loginLink') ?></a>
        </p>
    </div>
    <?= form_close() ?>
</div>
<?= $this->endSection() ?>

<?= $this->section('pageScripts') ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // --- Logika untuk KTA -> Tanggal Lahir ---
        const ktaInput = document.getElementById('kta_number');
        const birthDateInput = document.getElementById('birth_date');
        const birthDateHelp = document.getElementById('birth_date_help');

        function toggleBirthDate() {
            if (ktaInput.value.trim() !== '') {
                birthDateInput.disabled = false;
                birthDateInput.required = true;
                birthDateHelp.classList.add('text-red-600', 'font-semibold');
                birthDateHelp.classList.remove('text-gray-500');
            } else {
                birthDateInput.disabled = true;
                birthDateInput.required = false;
                birthDateInput.value = '';
                birthDateHelp.classList.remove('text-red-600', 'font-semibold');
                birthDateHelp.classList.add('text-gray-500');
            }
        }
        toggleBirthDate();
        ktaInput.addEventListener('input', toggleBirthDate);

        // --- LOGIKA BARU UNTUK NOMOR TELEPON ---
        const phoneInput = document.getElementById('phone_number');

        // Fungsi untuk memastikan format selalu benar
        function formatPhoneNumber() {
            // Jika field tidak kosong dan tidak diawali dengan '+', tambahkan.
            if (phoneInput.value.length > 0 && phoneInput.value[0] !== '+') {
                phoneInput.value = '+' + phoneInput.value;
            }
            
            // Mencegah pengguna menghapus tanda '+' jika masih ada angka setelahnya
            if (phoneInput.value.length > 1 && phoneInput.value[0] !== '+') {
                 phoneInput.value = '+' + phoneInput.value.replace(/\+/g, '');
            }
        }
        
        // Tambahkan '+' saat pengguna pertama kali fokus jika field kosong
        phoneInput.addEventListener('focus', function() {
            if (this.value === '') {
                this.value = '+';
            }
        });

        // Jalankan format setiap kali pengguna mengetik
        phoneInput.addEventListener('input', formatPhoneNumber);
    });
</script>
<?= $this->endSection() ?>