<?php helper('permission'); // Muat helper permission ?>
<div :class="sidebarOpen ? 'block' : 'hidden'" @click="sidebarOpen = false" class="fixed z-20 inset-0 bg-black opacity-50 transition-opacity lg:hidden"></div>

<div :class="sidebarOpen ? 'translate-x-0 ease-out' : '-translate-x-full ease-in'" class="fixed z-30 inset-y-0 left-0 w-64 transition duration-300 transform bg-gray-900 overflow-y-auto lg:translate-x-0 lg:static lg:inset-0">
    <div class="flex items-center justify-center mt-8">
        <div class="flex items-center">
            <span class="text-white text-2xl mx-2 font-semibold">Admin Panel</span>
        </div>
    </div>

    <nav class="mt-10">
        <!-- Dashboard -->
        <a class="flex items-center mt-4 py-2 px-6 <?= (url_is('backend/dashboard*')) ? 'bg-gray-700 bg-opacity-25 text-gray-100' : 'text-gray-400 hover:bg-gray-700 hover:bg-opacity-25 hover:text-gray-100' ?>" href="<?= route_to('admin.dashboard') ?>">
            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/></svg>
            <span class="mx-3"><?= lang('Admin/Layout.dashboard') ?></span>
        </a>

        <!-- Master Data -->
        <?php if(has_permission('create-church')): // Judul grup hanya muncul jika ada isinya ?>
            <p class="px-6 pt-6 text-xs uppercase text-gray-500 font-semibold tracking-wider">Master Data</p>
            <a class="flex items-center mt-2 py-2 px-6 <?= (url_is('backend/churches*')) ? 'bg-gray-700 bg-opacity-25 text-gray-100' : 'text-gray-400 hover:bg-gray-700 hover:bg-opacity-25 hover:text-gray-100' ?>" href="#">
                <span class="mx-3"><?= lang('Admin/Layout.churches') ?></span>
            </a>
        <?php endif; ?>

        <!-- User Management -->
        <?php if(has_permission('view-user-list')): ?>
            <p class="px-6 pt-6 text-xs uppercase text-gray-500 font-semibold tracking-wider">User Management</p>
            <a class="flex items-center mt-2 py-2 px-6 <?= (url_is('backend/users*')) ? 'bg-gray-700 bg-opacity-25 text-gray-100' : 'text-gray-400 hover:bg-gray-700 hover:bg-opacity-25 hover:text-gray-100' ?>" href="<?= route_to('admin.users.index') ?>">
                <span class="mx-3">Users</span>
            </a>
        <?php endif; ?>

        <!-- Transactions -->
        <?php if(has_permission('view-transaction-list') || has_permission('create-event') || has_permission('create-promotion')): ?>
            <p class="px-6 pt-6 text-xs uppercase text-gray-500 font-semibold tracking-wider"><?= lang('Admin/Layout.transactions') ?></p>
            <?php if(has_permission('create-event')): ?>
                <a class="flex items-center mt-2 py-2 px-6 <?= (url_is('backend/events*')) ? 'bg-gray-700 bg-opacity-25 text-gray-100' : 'text-gray-400 hover:bg-gray-700 hover:bg-opacity-25 hover:text-gray-100' ?>" href="#">
                    <span class="mx-3"><?= lang('Admin/Layout.events') ?></span>
                </a>
            <?php endif; ?>
            <?php if(has_permission('create-promotion')): ?>
                <a class="flex items-center mt-2 py-2 px-6 <?= (url_is('backend/promotions*')) ? 'bg-gray-700 bg-opacity-25 text-gray-100' : 'text-gray-400 hover:bg-gray-700 hover:bg-opacity-25 hover:text-gray-100' ?>" href="#">
                    <span class="mx-3"><?= lang('Admin/Layout.promotions') ?></span>
                </a>
            <?php endif; ?>
            <?php if(has_permission('view-transaction-list')): ?>
                <a class="flex items-center mt-2 py-2 px-6 <?= (url_is('backend/transactions*')) ? 'bg-gray-700 bg-opacity-25 text-gray-100' : 'text-gray-400 hover:bg-gray-700 hover:bg-opacity-25 hover:text-gray-100' ?>" href="<?= site_url('backend/transactions') ?>">
                    <span class="mx-3"><?= lang('Admin/Layout.data_trx') ?></span>
                </a>
            <?php endif; ?>
        <?php endif; ?>

        <!-- Reports -->
        <?php if(has_permission('view-participant-report')): ?>
            <p class="px-6 pt-6 text-xs uppercase text-gray-500 font-semibold tracking-wider">Reports</p>
            <a class="flex items-center mt-2 py-2 px-6 <?= (url_is('backend/reports/participants*')) ? 'bg-gray-700 bg-opacity-25 text-gray-100' : 'text-gray-400 hover:bg-gray-700 hover:bg-opacity-25 hover:text-gray-100' ?>" href="<?= route_to('admin.reports.participants') ?>">
                <span class="mx-3">Participant Report</span>
            </a>
        <?php endif; ?>

        <!-- Configuration -->
        <?php if(has_permission('view-admin-list') || has_permission('view-role-list')): ?>
            <p class="px-6 pt-6 text-xs uppercase text-gray-500 font-semibold tracking-wider"><?= lang('Admin/Layout.configuration') ?></p>
            <?php if(has_permission('view-admin-list')): ?>
                <a class="flex items-center mt-2 py-2 px-6 <?= (url_is('backend/admins*')) ? 'bg-gray-700 bg-opacity-25 text-gray-100' : 'text-gray-400 hover:bg-gray-700 hover:bg-opacity-25 hover:text-gray-100' ?>" href="<?= route_to('admin.admins.index') ?>">
                    <span class="mx-3"><?= lang('Admin/Layout.admins') ?></span>
                </a>
            <?php endif; ?>
            <?php if(has_permission('view-role-list')): ?>
                <a class="flex items-center mt-2 py-2 px-6 <?= (url_is('backend/roles*')) ? 'bg-gray-700 bg-opacity-25 text-gray-100' : 'text-gray-400 hover:bg-gray-700 hover:bg-opacity-25 hover:text-gray-100' ?>" href="<?= route_to('admin.roles.index') ?>">
                    <span class="mx-3"><?= lang('Admin/Layout.roles') ?></span>
                </a>
            <?php endif; ?>
        <?php endif; ?>
    </nav>
</div>