<?php

namespace App\Models;

use CodeIgniter\Model;

class EventFieldModel extends Model
{
    protected $table            = 'event_fields';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;

    protected $allowedFields    = [
        'event_id', 
        'field_key', 
        'label', 
        'type', 
        'is_multiple', 
        'is_required', 
        'options', 
        'sort_order'
    ];

    protected $useTimestamps    = false;

    protected $validationRules = [
        'event_id'    => 'required|is_natural_no_zero',
        'field_key'   => 'required|alpha_dash|max_length[100]',
        'label'       => 'required|max_length[100]',
        'type'        => 'required|in_list[text,number,date,email,select]',
        'is_required' => 'in_list[0,1]',
        'is_multiple' => 'in_list[0,1]',
    ];
}