<?php

namespace App\Models;

use CodeIgniter\Model;

class ChurchModel extends Model
{
    protected $table            = 'churches';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;

    protected $allowedFields = ['name', 'sort_order', 'city', 'region', 'is_gka', 'is_active'];

    protected $order  = 'sort_order ASC, name ASC';

    protected $useTimestamps    = false;

    protected $validationRules = [
        'name'      => 'required|max_length[150]|is_unique[churches.name,id,{id}]',
        'city'      => 'permit_empty|max_length[100]',
        'region'    => 'permit_empty|max_length[100]',
        'is_active' => 'in_list[0,1]',
    ];

    public function findAll($limit = 0, $offset = 0)
    {
        return $this->builder()
                    ->where('is_active', 1)
                    ->orderBy('sort_order', 'ASC')
                    ->orderBy('name', 'ASC')
                    ->get($limit, $offset)
                    ->getResult($this->returnType);
    }
}