<?php

namespace App\Models;

use CodeIgniter\Model;

class BroadcastTemplateModel extends Model
{
    protected $table            = 'broadcast_templates';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;

    protected $allowedFields    = ['event_id', 'title', 'body', 'type'];

    protected $useTimestamps    = false;

    protected $validationRules = [
        'event_id' => 'required|is_natural_no_zero',
        'title'    => 'required|max_length[100]',
        'body'     => 'required',
        'type'     => 'required|in_list[email,whatsapp]',
    ];
}