<?php
// app/Database/Seeds/PermissionsSeeder.php
namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class PermissionsSeeder extends Seeder
{
    public function run()
    {
        $permissions = [
            // Master - Church
            ['name' => 'create-church', 'description' => 'Allow user to create new churches'],
            ['name' => 'edit-church',   'description' => 'Allow user to edit existing churches'],
            ['name' => 'delete-church', 'description' => 'Allow user to delete churches'],

            // Users
            ['name' => 'view-user-list', 'description' => 'Allow user to view the list of all frontend users'],
            ['name' => 'edit-user',      'description' => 'Allow user to edit frontend user data'],
            ['name' => 'delete-user',    'description' => 'Allow user to delete frontend users and their transactions'],
            
            
            // Transaction - Events
            ['name' => 'create-event', 'description' => 'Allow user to create new events'],
            ['name' => 'edit-event',   'description' => 'Allow user to edit existing events'],
            ['name' => 'delete-event', 'description' => 'Allow user to delete events'],
            
            // Transaction - Promotions
            ['name' => 'create-promotion', 'description' => 'Allow user to create new promotions'],
            ['name' => 'edit-promotion',   'description' => 'Allow user to edit existing promotions'],
            ['name' => 'delete-promotion', 'description' => 'Allow user to delete promotions'],

            // Transaction - Data Transaction
            ['name' => 'view-transaction-list', 'description' => 'Allow user to view the list of all transactions'],
            ['name' => 'view-transaction-detail', 'description' => 'Allow user to view the details of a single transaction'],
            ['name' => 'edit-transaction', 'description' => 'Allow user to change transaction status'],
            ['name' => 'edit-participant', 'description' => 'Allow user to edit participant data'],

            // Transaction - Report Peserta
            ['name' => 'view-participant-report', 'description' => 'Allow user to view and export participant report'],

            // Broadcast - Template
            ['name' => 'create-template', 'description' => 'Allow user to create broadcast templates'],
            ['name' => 'edit-template',   'description' => 'Allow user to edit broadcast templates'],
            ['name' => 'delete-template', 'description' => 'Allow user to delete broadcast templates'],
            
            // Broadcast - Send
            ['name' => 'send-broadcast', 'description' => 'Allow user to send broadcasts'],
            
            // Configuration - Admins
            ['name' => 'view-admin-list', 'description' => 'Allow user to view the list of admins'],
            ['name' => 'create-admin', 'description' => 'Allow user to create new admins'],
            ['name' => 'edit-admin',   'description' => 'Allow user to edit existing admins'],
            ['name' => 'delete-admin', 'description' => 'Allow user to delete admins'],
            
            // Configuration - Roles
            ['name' => 'view-role-list', 'description' => 'Allow user to view the list of all roles'],
            ['name' => 'create-role', 'description' => 'Allow user to create new roles'],
            ['name' => 'edit-role',   'description' => 'Allow user to edit existing roles'],
            ['name' => 'delete-role', 'description' => 'Allow user to delete roles'],

            // Util
            ['name' => 'manage-system', 'description' => 'Allow user to manage cache system'],
        ];

        // Menggunakan query builder untuk insert data dan mengabaikan jika sudah ada
        foreach ($permissions as $permission) {
            $this->db->table('permissions')->ignore(true)->insert($permission);
        }
    }
}