<header class="bg-white shadow-md sticky top-0 z-50">
    <nav class="container mx-auto px-4 py-3 flex justify-between items-center">
        <!-- Logo -->
        <a href="<?= site_url() ?>" class="text-2xl font-bold text-indigo-600">Event Registration</a>
        
        <!-- Menu Kanan (Dinamis) -->
        <div class="flex items-center space-x-4">

            <?php if (session()->get('isLoggedIn')): ?>
                <!-- JIKA PENGGUNA SUDAH LOGIN -->
                <div class="relative" x-data="{ open: false }" @click.away="open = false" id="user-menu-container">
                    <!-- Tombol Dropdown dengan Nama Pengguna -->
                    <button @click="open = !open" id="user-menu-button" class="flex items-center space-x-2 px-3 py-1 rounded-md hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        <span>Hi, <?= esc(session()->get('user_name')) ?></span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                    </button>

                    <!-- Konten Dropdown Menu -->
                    <div x-show="open" 
                         x-transition:enter="transition ease-out duration-100"
                         x-transition:enter-start="transform opacity-0 scale-95"
                         x-transition:enter-end="transform opacity-100 scale-100"
                         x-transition:leave="transition ease-in duration-75"
                         x-transition:leave-start="transform opacity-100 scale-100"
                         x-transition:leave-end="transform opacity-0 scale-95"
                         id="user-menu" 
                         class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1"
                         style="display: none;">
                        <a href="<?= route_to('dashboard.show') ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-indigo-500 hover:text-white">Dashboard</a>
                        
                        <!-- ====== PERUBAHAN DI SINI ====== -->
                        <a href="<?= route_to('profile.show') ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-indigo-500 hover:text-white">Profile</a>
                        <!-- =============================== -->
                        
                        <div class="border-t border-gray-100 my-1"></div>
                        <a href="<?= route_to('logout') ?>" class="block w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-red-500 hover:text-white">Logout</a>
                    </div>
                </div>

            <?php else: ?>
                <!-- JIKA PENGGUNA BELUM LOGIN (TAMU) -->
                <a href="<?= route_to('login.show') ?>" class="text-gray-600 hover:text-indigo-600 font-medium">Login</a>
                <a href="<?= route_to('register.show') ?>" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded-lg transition duration-300">Register</a>
            
            <?php endif; ?>

        </div>
    </nav>
</header>

<!-- (Opsional) JavaScript diganti dengan Alpine.js untuk konsistensi -->
<!-- Skrip lama yang menggunakan getElementById bisa dihapus jika Anda menggantinya dengan Alpine -->