<header class="flex justify-between items-center py-4 px-6 bg-white border-b-4 border-indigo-600">
    <div class="flex items-center">
        <button @click="sidebarOpen = true" class="text-gray-500 focus:outline-none lg:hidden">
            <svg class="h-6 w-6" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M4 6H20M4 12H20M4 18H11" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
        </button>
    </div>

    <div class="flex items-center">
        <div x-data="{ dropdownOpen: false }" class="relative">
            <button @click="dropdownOpen = ! dropdownOpen" class="relative block h-8 w-8 rounded-full overflow-hidden shadow focus:outline-none">
                <img class="h-full w-full object-cover" src="https://ui-avatars.com/api/?name=<?= urlencode(session()->get('user_name')) ?>&background=4f46e5&color=fff" alt="Your avatar">
            </button>

            <div x-show="dropdownOpen" @click="dropdownOpen = false" class="fixed inset-0 h-full w-full z-10" style="display: none;"></div>

            <div x-show="dropdownOpen" class="absolute right-0 mt-2 w-48 bg-white rounded-md overflow-hidden shadow-xl z-10" style="display: none;">
                <a href="<?= route_to('admin.profile.show') ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-indigo-600 hover:text-white"><?= lang('Admin/Layout.profile') ?></a>
                <a href="<?= route_to('admin.logout') ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-indigo-600 hover:text-white"><?= lang('Admin/Layout.logout') ?></a>
            </div>
        </div>
    </div>
</header>