<?php

namespace App\Models;

use CodeIgniter\Model;

class PromotionModel extends Model
{
    protected $table            = 'promotions';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;

    protected $allowedFields    = [
        'event_id',
        'name',
        'code',
        'description',
        'quota',
        'used_quota',
        'min_quantity',
        'max_quantity',
        'min_amount',
        'max_amount',
        'discount_amount',
        'discount_percent',
        'start_date',
        'end_date',
        'is_active'
    ];

    protected $useTimestamps = true; // Hanya ada created_at
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
}